#include "MySprite.h"

MySprite::MySprite()
{
	scale = 220.f;
	gravity = 9.8f * scale;
}

MySprite::~MySprite()
{}

// override this function to provide functionality
void MySprite::update(float dt)
{
}

// Sets the velocity of the sprite
void MySprite::setVelocity(sf::Vector2f vel)
{
	velocity = vel;
}
void MySprite::setVelocity(float vx, float vy)
{
	velocity.x = vx;
	velocity.y = vy;
}

// get sprite velocity
sf::Vector2f MySprite::getVelocity()
{
	return velocity;
}

// Returns collision box + position, giving the collision box in the correct position
sf::FloatRect MySprite::getCollisionBox() { 
	
	return sf::FloatRect(collisionBox.left + getPosition().x, collisionBox.top + getPosition().y, collisionBox.width, collisionBox.height); 
}

// Reponse function, what the sprite does based on collision
// Colliding object is passed in for information
// e.g. compare sprite positions to determine new velocity direction.
// e.g. checking sprite type (world, enemy, bullet etc) so response is based on that.
void MySprite::collisionResponse(MySprite * sp)
{
}

bool MySprite::getInvincible()
{
	return isInvincible;
}

void MySprite::setInvincible(bool val, float duration)
{
	isInvincible = val;	//Set isInvincible to val
	invincibilityTime = duration;	//The sprite will be invincible for duration seconds
}

float MySprite::getInvincibilityTime()
{
	return invincibilityTime;
}

void MySprite::setAirbourne(bool air)
{
	isAirbourne = air;	//Set isAirbourne to air
}

bool MySprite::getAirbourne()
{
	return isAirbourne;	//Return whether or not the sprite is airbourne
}

MySprite::SpriteType MySprite::getSpriteType()
{
	return spriteType;	//Return the type of this sprite (used for casting to access member functions)
}